<?PHP
class Spark_APIv1 {

	public $KEY_1 = ""; // Ключ 1
	public $KEY_2 = ""; // Ключ 2
	public $KEY_PAYOUT = ''; // Ключ для выплат
	
	public $error_desc = ''; // Для текстового описания ошибки
	
	private $BASE_URL = 'https://spark-api.cc/v1/';
	
	

	// Метод call : вызвать API
	// call( назв_метода , массив_параметров )
    public function call( $method , $data_arr = [] ) {
		if (!in_array('curl', get_loaded_extensions())) {
			$this->error_desc = "Для работы класса необходима библиотека cURL";
			return false;
		}
        $key = '';
		if ($method == 'makePayout') {
			if ($this->KEY_PAYOUT == '') {
				$this->error_desc = "Для вызова makePayout нужно указать KEY_PAYOUT";
				return false;
			} else $key = $this->KEY_PAYOUT;
		} else {
			if ($this->KEY_1 == '') {
				$this->error_desc = "Для вызова {$method} нужно указать KEY_1";
				return false;
			} else $key = $this->KEY_1;
		}
		
		$data_arr['sign'] = $this->makeSign( $data_arr , $key );
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $this->BASE_URL . $method);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data_arr) );
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		//curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		//curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
		
		curl_setopt($ch, CURLOPT_USERAGENT, 'SpicyCash_APIv1 PHP Class');

		$server_output = curl_exec($ch);
		
		$answer_code = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
		curl_close ($ch);
		
		if ($answer_code != 200) {
			$this->error_desc = "Не удалось получить ответ от API, код: {$answer_code} ";
			return false;
		}
		$arr = json_decode( $server_output , true);
		
		if (!isset($arr['status'])) {
			$this->error_desc = "Некорректный ответ от API : {$server_output} ";
			return false;
		}
		if ($arr['status'] == 'OK') return $arr['result'];
		else {
			$this->error_desc = $arr['description'];
			return false;
		}
    }


	// Метод checkCallback : проверить подпись полученного коллбека
	// checkCallback( $_POST )
	public function checkCallback($dataSet) {
		if ($this->KEY_2 == '') {
			$this->error_desc = "Для вызова checkCallback() нужно указать KEY_2";
			return false;
		}
		if (!isset($dataSet['sign'])) {
			$this->error_desc = "Подпись (поле sign) отсутствует!";
			return false;
		}
		$SIGN = $dataSet['sign'];
		if ($SIGN == $this->makeSign( $dataSet , $this->KEY_2 )) return true;
		else {
			$this->error_desc = "Подпись неверная";
			return false;
		}
	}
	
	
	
	public function makeSign($dataSet , $key) {
		if (isset($dataSet['sign'])) unset($dataSet['sign']);
		ksort($dataSet, SORT_STRING); 
		array_push($dataSet, $key);
		$signString = implode(';', $dataSet);
		$sign = md5( $signString );
		return $sign;
	}


}
